/**
	\file
	\brief		Header file for general Illustrator mesh art manipulation
	\copyright	Hot Door, Inc. 2010-2025
*/

#ifndef __HDI_CORE_MESH_ART__
#define __HDI_CORE_MESH_ART__

#if defined(HDI_CORE_AIP_MODE)

#include "hdicoreTypes.h"

namespace hdi
{
	namespace core
	{
		class Art;
	
		/**
			\brief	Allows for mesh manipulation, metadata access, etc.
		*/
		class MeshArt
		{
			public:
				/**
					\brief	Describes the type of an Illustrator mesh
				*/
				enum MeshType
				{
					UnknownMeshType		= 0,
					CartesianMeshType	= 10,
					PolarMeshType		= 20	// Reserved for future use
				};
			
				/**
					\brief	Destructs a MeshArt object
					\author	GW
					\date	08/2014
				*/
				~MeshArt();
				
				/**
					\brief		Creates a cartesian mesh for the related art object
					\author		GW
					\date		08/2014
					
					\param		numI_	Number of patches along the I axis
					\param		numJ_	Number of patches along the J axis
					\returns	true if the mesh could be created, false otherwise
				*/
				bool createCartesian(const int32_t numI_, const int32_t numJ_);
				
				/**
					\brief		Gets the type of mesh
					\author		GW
					\date		08/2014
					
					\returns	The mesh type
				*/
				MeshType meshType() const;
				
				/**
					\brief		Gets the size of the target mesh (number of patches)
					\author		GW
					\date		08/2014
					
					\param		numI__	Return-by-reference for the number of I axis patches
					\param		numJ__	Return-by-reference for the number of J axis patches
					\returns	true if the dimensions could be acquired, false otherwise
				*/
				bool cartesianSize(int32_t& numI__, int32_t& numJ__) const;
				
				// TODO further implement this class


			private:
				// Only Art can construct a new MeshArt object
				friend class Art;

				/**
					\brief	Art to which this mesh belongs
				*/
				void* __data;
				
				/**
					\brief	Empty MeshArt objects cannot be constructed
					\author	GW
					\date	08/2014
				*/
				MeshArt();

				/**
					\brief	Constructs a new MeshArt object from a given Art object
					\author	GW
					\date	08/2014

					\param	art_	Pointer for the existing art we're wrapping around
				*/
				MeshArt(void* const art_);
			
				/**
					\brief	MeshArt objects cannot be copied
					\author	GW
					\date	08/2014
				*/
				MeshArt(const MeshArt&);
			
				/**
					\brief	MeshArt objects cannot be copied
					\author	GW
					\date	08/2013
				*/
				MeshArt& operator=(const MeshArt&);
		};
	}
}

#endif
// HDI_CORE_AIP_MODE

#endif
// __HDI_CORE_MESH_ART__
