#ifndef __HDI_CORE_AIP_PIPL__
#define __HDI_CORE_AIP_PIPL__

// Version of PiPL template described in this file
#ifndef kPIPropertiesVersion
	#define kPIPropertiesVersion 0
#endif

// Template
type 'PiPL'
{
	longint = kPIPropertiesVersion;
	longint = $$CountOf(properties);
	array properties
	{
		switch
		{
			//-------------------------------------------------------------------
			// Illustrator/Sweet Pea PiPL properties
			//-------------------------------------------------------------------

			case ADBEKind:
				longint = 'ADBE';			// Suite Pea/Illustrator host
				key longint = 'kind';
				longint = 0;				// Index
				longint = 4;				// Length
				literal longint PIPiPLTypes;// Version

			case InterfaceVersion:
				longint = 'ADBE';		// Suite Pea/illustrator host
				key longint = 'ivrs';
				longint = 0;			// Index
				longint = 4;			// Length
				longint;				// Version

			case ADBECodeCarbon:
				longint = 'ADBE';
				key longint = 'ppcb';
				longint = 0;
				#if DeRez
					fill long;
				#else
					longint = (ADBEppcbEnd[$$ArrayIndex(properties)] - ADBEppcbStart[$$ArrayIndex(properties)]) / 8;
				#endif
			  ADBEppcbStart:
				longint;
				longint;
				pstring;
			  ADBEppcbEnd:
				align long;

			case ADBECodeMachO:
				longint = 'ADBE';
				key longint = 'mach';
				longint = 0;
				#if DeRez
					fill long;
				#else
					longint = (ADBEmachEnd[$$ArrayIndex(properties)] - ADBEmachStart[$$ArrayIndex(properties)]) / 8;
				#endif
			  ADBEmachStart:
				pstring;
			  ADBEmachEnd:
				align long;

			case ADBECodeMacIntel32:
				longint = 'ADBE';
				key longint = 'mi32';
				longint = 0;
				#if DeRez
					fill long;
				#else
					longint = (ADBEmi32End[$$ArrayIndex(properties)] - ADBEmi32Start[$$ArrayIndex(properties)]) / 8;
				#endif
			  ADBEmi32Start:
				pstring;
			  ADBEmi32End:
				align long;

			case SP_STSP:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'StsP';
				longint = 0;			// Index
				longint = 4;			// Length
				longint;

			case InternalName:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'pinm';
				longint = 0;			// Index
				#if DeRez
					fill long;
				#else
					longint = (plugInNameEnd[$$ArrayIndex(properties)] - plugInNameStart[$$ArrayIndex(properties)]) / 8;
				#endif
				plugInNameStart:
					cstring;
				plugInNameEnd:
					align long;

			case BuildVersion:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'bvrs';
				longint = 0;			// Index
				longint = 4;			// Length
				longint;				// Version

			case ADBEVersion:
				longint = 'ADBE';
				key longint = 'vers';
				longint = 0;
				longint = 4;
				longint;

			case ADBECategory:
				longint = 'ADBE';
				key longint = 'catg';
				longint = 0;
				#if DeRez
					fill long;
				#else
					longint = (ADBEcatgEnd[$$ArrayIndex(properties)] - ADBEcatgStart[$$ArrayIndex(properties)]) / 8;
				#endif
			  ADBEcatgStart:
				pstring
					// Use Help category to put automation plugins in the "Help" menu:
					PSHelpMenu = "**Help**",

					// Use Hidden category to keep plugins out of menus.
					// WARNING: The only way to access a hidden plugin is
					// by calling it by its event ID from the Play callback!
					PSHidden = "**Hidden**",

					// Use Copyright-Checker category to detect copyrights on first-opened files:
					PSCopyrightChecker = "**Copyright-Checker**";

			  ADBEcatgEnd:
				align long;

			case ADBEName:
				longint = 'ADBE';
				key longint = 'name';
				longint = 0;
				#if DeRez
					fill long;
				#else
					longint = (ADBEnameEnd[$$ArrayIndex(properties)] - ADBEnameStart[$$ArrayIndex(properties)]) / 8;
				#endif
			  ADBEnameStart:
				pstring;
			  ADBEnameEnd:
				align long;

			case AdapterVersion:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'adpt';
				longint = 0;			// Index
				longint = 4;			// Length
				longint;				// Version

			case Imports:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'impt';
				longint = 0;			// Index
				#if DeRez
					fill long;
				#else
					longint = (importsEnd[$$ArrayIndex(properties)] - importsStart[$$ArrayIndex(properties)]) / 8;
				#endif
				importsStart:
					longint = $$CountOf(ImportSuites);
					wide array ImportSuites
					{
						isuitesStart:
							// Length (including this long):
							#if DeRez
								fill long;
							#else
								longint = ((isuitesEnd[$$ArrayIndex(properties), $$ArrayIndex(ImportSuites)] - isuitesStart[$$ArrayIndex(properties), $$ArrayIndex(ImportSuites)]) / 8);
							#endif

							cstring;
							align long;
							longint;	// Suite version
						isuitesEnd:
					};
				importsEnd:

			case Exports:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'expt';
				longint = 0;			// Index
				#if DeRez
					fill long;
				#else
					longint = (exportsEnd[$$ArrayIndex(properties)] - exportsStart[$$ArrayIndex(properties)]) / 8;
				#endif
				exportsStart:
					longint = $$CountOf(ExportSuites);
					wide array ExportSuites
					{
						esuitesStart:
							// Length (including this long):
							#if DeRez
								fill long;
							#else
								longint = ((esuitesEnd[$$ArrayIndex(properties), $$ArrayIndex(ExportSuites)] - esuitesStart[$$ArrayIndex(properties), $$ArrayIndex(ExportSuites)]) / 8);
							#endif

							cstring;
							align long;
							longint;	// Suite version
						esuitesEnd:
					};
				exportsEnd:

			case Messages:
				longint = 'ADBE';		// Suite Pea/Illustrator host
				key longint = 'AcpM';
				longint = 0;			// Index
				longint = 4;			// Length
				fill bit[28];			// Reserved

				boolean startupRequired, noStartupRequired;
				boolean doesNotPurgeCache, purgeCache;
				boolean shutdownRequired, noShutdownRequired;	// Default is to give shutdown msg
				boolean doNotAcceptProperty, acceptProperty;

		};
	};
};

#undef PIPiPLTypes



// This defines the name of the plugin, not to exceed 16 chars
#ifndef PIPL_PLUGIN_NAME
	#error Need to define plugin name
#endif

// Define this if your plugin exports any suites; this will guarantee them being earlier in the load order
#ifndef PIPL_EXPORT
	#define PIPL_EXPORT 0
#endif

#if PIPL_EXPORT && !defined(PIPL_EXPORTED_SUITES)
	#define PIPL_EXPORTED_SUITES {}

	// If you do define exported suites, the list should be like the one below:
	// (the first entry is the suite name, the second is the suite version)
	// #define PIPL_EXPORTED_SUITES { "Exported Suite", 1 }
#endif

#ifndef PIPL_MESSAGE
	#define PIPL_MESSAGE 0

	// Define PIPL_MESSAGES as a list of the messages you want
	// #define PIPL_MESSAGES startupRequired,purgeCache,shutdownRequired,acceptProperty
#endif

// If you are an adaptor plugin, define this
#ifndef PIPL_ADAPTOR
	#define PIPL_ADAPTOR 0
#endif

#define TARGET ADBECodeCarbon
#ifndef PPC_PIPL_ENTRY
	#define PPC_PIPL_ENTRY	0,0,""
#endif

#define TARGET1 ADBECodeMachO
#ifndef PIPL_ENTRY
	#define PIPL_ENTRY	""
#endif

#define TARGET2 ADBECodeMacIntel32
#ifndef PIPL_ENTRY
	#define PIPL_ENTRY	""
#endif

resource 'PiPL' (16000, PIPL_PLUGIN_NAME " PiPL")
{
	{
		ADBEKind {'SPEA'},
		InterfaceVersion { 2 },
		TARGET
		{
			PPC_PIPL_ENTRY
		},
		TARGET1
		{
			PIPL_ENTRY
		},
		TARGET2
		{
			PIPL_ENTRY
		},
	#if PIPL_EXPORT
		Exports
		{
			PIPL_EXPORTED_SUITES
		},
	#endif
	#if PIPL_MESSAGE
		Messages
		{
			PIPL_MESSAGES
		},
	#endif
	#if PIPL_ADAPTOR
		AdapterVersion { 2 }
	#endif
		InternalName
		{
			PIPL_PLUGIN_NAME
		}
	}
};

#endif
// __HDI_CORE_AIP_PIPL__
