#ifndef __TOOL_SAMPLE_PLUGIN__
#define __TOOL_SAMPLE_PLUGIN__

#include "hdicoreCursor.h"
#include "hdicoreTextField.h"
#include "hdicoreTool.h"

#define TOOL_PLUG_INST	tool::Plugin::instance()

namespace hdi
{
	namespace core
	{
		class Plugin;
	}
}

namespace tool
{
	class Plugin
	{
		public:
			/**
				\brief		Creates the singleton instance of the tool sample Plugin class
				\author		GW
				\date		10/2013
				
				\param		corePlug_	Pointer to the core Plugin object, as received by hdi::core::pluginSetup()
				
				\returns	The Plugin instance object
			*/
			static Plugin* const create(hdi::core::Plugin* const corePlug_);
		
			/**
				\brief		Acquires the singleton instance of the tool sample Plugin class
				\author		GW
				\date		10/2013
				
				\returns	The Plugin instance object
				
				\note		This method will always return NULL until create() has been called
			*/
			static Plugin* const instance();
			
			/**
				\brief	Destroys the singleton instance of the tool sample Plugin class
				\author	GW
				\date	10/2013
			*/
			static void destroy();
			
			/**
				\brief	Will be called when the plug-in is starting up (as set in toolSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void startup();
			
			/**
				\brief	Will be called when the plug-in has already started up, but still needs to set some things up
						(as set in toolSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void postStartup();
			
			/**
				\brief	Will be called when the plug-in is about to shutdown (as set in toolSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void preShutdown();
			
			/**
				\brief	Will be called when the plug-in is fully shutting down (as set in toolSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void shutdown();


		private:
			/**
				\brief	Singleton instance of the tool sample Plugin class
			*/
			static Plugin* __instance;
			
			/**
				\brief	Pointer to the core Plugin object
			*/
			hdi::core::Plugin* __corePlug;
			
			/**
				\brief	Crosshairs cursor for tools to use
			*/
			hdi::core::Cursor __crosshairsCrsr;
			
			/**
				\brief	Tool for generating simple gears
			*/
			hdi::core::Tool __gearTool;
			
			/**
				\brief	Text field for user input for the desired gear diameter
			*/
			hdi::core::TextField __gearToolGearDiamField;
			
			/**
				\brief	Text field for user input for the desired number of gear teeth
			*/
			hdi::core::TextField __gearToolNumTeethField;
			
			/**
				\brief	Text field for user input for the desired gear tooth length
			*/
			hdi::core::TextField __gearToolToothLengthField;
			
			/**
				\brief	Text field for user input for the desired rim diameter
			*/
			hdi::core::TextField __gearToolRimDiamField;
			
			/**
				\brief	Text field for user input for the desired hub diameter
			*/
			hdi::core::TextField __gearToolHubDiamField;
			
			/**
				\brief	Text field for user input for the desired bore diameter
			*/
			hdi::core::TextField __gearToolBoreDiamField;

			/**
				\brief	Tool sample Plugin constructor
				\author	GW
				\date	10/2013
			*/
			Plugin(hdi::core::Plugin* const corePlug_);

			/**
				\brief	Destructs a tool sample Plugin object
				\author	GW
				\date	10/2013
			*/
			~Plugin();
			
			/**
				\brief	Called when a gear tool config widget's value has changed
				\author	GW
				\date	10/2013
			*/
			void __gearToolUpdateModalWidgetsCB();
			
			/**
				\brief	Called when the gear tool has been dragged
				\author	GW
				\date	10/2013
			*/
			void __gearToolDragCB();
			
			/**
				\brief	Called when the mouse button has gone up with gear tool selected
				\author	GW
				\date	10/2013
			*/
			void __gearToolMouseUpCB();
			
			/**
				\brief	Called when the gear tool should draw from input given in the modal input dialog
				\author	GW
				\date	10/2013
			*/
			void __gearToolDrawInputCB();
			
			/**
				\brief		Verifies if all the gear tool widgets have been filled out appropriately
				\author		GW
				\date		10/2013
				
				\param		emptyAllowed_	true if an empty text field is allowed, false otherwise
				\param		numTeeth__		Return-by-reference for the number of gear teeth
				\param		toothLength__	Return-by-reference for the length of each tooth
				\param		rimDiam__		Return-by-reference for the gear rim diameter
				\param		hubDiam__		Return-by-reference for the gear hub diameter
				\param		boreDiam__		Return-by-reference for the gear bore diameter
			*/
			bool __gearToolVerifyWidgets(
				const bool emptyAllowed_,
				double& numTeeth__,
				double& toothLength__,
				double& rimDiam__,
				double& hubDiam__,
				double& boreDiam__
			);
	};
}

#endif
// __TOOL_SAMPLE_PLUGIN__
