#ifndef __HDI_CORE_MEMORY__
#define __HDI_CORE_MEMORY__

#include <list>
#include <map>
#include <set>
#include <vector>

namespace hdi
{
	namespace core
	{
		/**
			\brief	Deletes the contained elements of a std::list object whose contained type is a pointer
			\author	GW
			\date	10/2014

			\param	l_	List whose elements need to be deleted
		*/
		template <typename Contained>
		void cleanupList(std::list< Contained* >& l_)
		{
			for(typename std::list< Contained* >::iterator iter = l_.begin(); iter != l_.end(); ++iter)
			{
				delete (*iter);
				(*iter) = NULL;
			}
			
			l_.clear();
		}
		
		/**
			\brief	Deletes the contained elements of a std::set object whose contained type is a pointer
			\author	GW
			\date	10/2014

			\param	s_	Set whose elements need to be deleted
		*/
		template <typename Contained>
		void cleanupSet(std::set< Contained* >& s_)
		{
			for(typename std::set< Contained* >::iterator iter = s_.begin(); iter != s_.end(); ++iter)
			{
				delete (*iter);
//				(*iter) = NULL;
			}
			
			s_.clear();
		}
		
		/**
			\brief	Deletes the contained elements of a std::vector object whose contained type is a pointer
			\author	GW
			\date	10/2014

			\param	v_	Vector whose elements need to be deleted
		*/
		template <typename Contained>
		void cleanupVector(std::vector< Contained* >& v_)
		{
			for(typename std::vector< Contained* >::iterator iter = v_.begin(); iter != v_.end(); ++iter)
			{
				delete (*iter);
				(*iter) = NULL;
			}
			
			v_.clear();
		}
		
		/**
			\brief	Deletes the contained elements of a std::map object whose second contained type is a pointer
			\author	GW
			\date	10/2014

			\param	m_	Map whose elements need to be deleted
		*/
		template <typename Contained1, typename Contained2>
		void cleanupMap(std::map< Contained1, Contained2* >& m_)
		{
			for(typename std::map< Contained1, Contained2* >::iterator iter = m_.begin(); iter != m_.end(); ++iter)
			{
				delete iter->second;
				iter->second = NULL;
			}
			
			m_.clear();
		}
		
		/**
			\brief	Deletes the contained elements of a std::map object whose first contained type is a pointer
			\author	GW
			\date	10/2014

			\param	m_	Map whose elements need to be deleted
		*/
		template <typename Contained1, typename Contained2>
		void cleanupMap(std::map< Contained1*, Contained2 >& m_)
		{
			for(typename std::map< Contained1*, Contained2 >::iterator iter = m_.begin(); iter != m_.end(); ++iter)
			{
				delete iter->first;
				// iter->first = NULL;
			}
			
			m_.clear();
		}
		
		/**
			\brief	Deletes the contained elements of a std::map object whose contained types are pointers
			\author	GW
			\date	10/2014

			\param	m_	Map whose elements need to be deleted
		*/
		template <typename Contained1, typename Contained2>
		void cleanupMap(std::map< Contained1*, Contained2* >& m_)
		{
			for(typename std::map< Contained1*, Contained2* >::iterator iter = m_.begin(); iter != m_.end(); ++iter)
			{
				delete iter->first;
				// iter->first = NULL;
				
				delete iter->second;
				iter->second = NULL;
			}
			
			m_.clear();
		}
	}
}

#endif
// __HDI_CORE_MEMORY__
