#ifndef __PANEL_SAMPLE_PLUGIN__
#define __PANEL_SAMPLE_PLUGIN__

#include "hdicoreButton.h"
#include "hdicoreLabel.h"
#include "hdicoreMenuGroup.h"
#include "hdicoreMenuItem.h"
#include "hdicorePanel.h"

namespace hdi
{
	namespace core
	{
		class Art;
		class Plugin;
	}
}

#define PANEL_PLUG_INST	panel::Plugin::instance()

namespace panel
{
	class Plugin
	{
		public:
			/**
				\brief		Creates the singleton instance of the panel Plugin class
				\author		GW
				\date		10/2013
				
				\param		corePlug_	Pointer to the core Plugin object, as received by hdi::core::pluginSetup()
				
				\returns	The Plugin instance object
			*/
			static Plugin* const create(hdi::core::Plugin* const corePlug_);
		
			/**
				\brief		Acquires the singleton instance of the panel Plugin class
				\author		GW
				\date		10/2013
				
				\returns	The Plugin instance object
				
				\note		This method will always return NULL until create() has been called
			*/
			static Plugin* const instance();
			
			/**
				\brief	Destroys the singleton instance of the panel Plugin class
				\author	GW
				\date	10/2013
			*/
			static void destroy();
			
			/**
				\brief	Will be called when the plug-in is starting up (as set in panelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void startup();
			
			/**
				\brief	Will be called when the plug-in has already started up, but still needs to set some things up
						(as set in panelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void postStartup();
			
			/**
				\brief	Will be called when the plug-in is about to shutdown (as set in panelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void preShutdown();
			
			/**
				\brief	Will be called when the plug-in is fully shutting down (as set in panelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void shutdown();


		private:
			/**
				\brief	Singleton instance of the panel Plugin class
			*/
			static Plugin* __instance;
			
			/**
				\brief	Pointer to the core Plugin object
			*/
			hdi::core::Plugin* __corePlug;
			
			/**
				\brief	PanelSample menu group
			*/
			hdi::core::MenuGroup __menuGroup;
			
			/**
				\brief	Menu item to show/hide the doc stats panel
			*/
			hdi::core::MenuItem __docPanelMenuItem;
			
			/**
				\brief	Number of seconds since the document was saved
			*/
			uint32_t __docSecsSinceSave;
			
			/**
				\brief	Document stats panel object
			*/
			hdi::core::Panel __docPanel;

			/**
				\brief	Label to indicate the current document name
			*/
			hdi::core::Label __docPanelNameLabel;

			/**
				\brief	Label to indicate how long since the document has been saved
			*/
			hdi::core::Label __docPanelSaveLabel;
			
			/**
				\brief	Button to save the current document
			*/
			hdi::core::Button __docPanelSaveButton;

			/**
				\brief	Label to indicate how many artboards the document has
			*/
			hdi::core::Label __docPanelArtboardsLabel;

			/**
				\brief	Label to indicate how many layers the document has
			*/
			hdi::core::Label __docPanelLayersLabel;

			/**
				\brief	Label to indicate how many groups the document has
			*/
			hdi::core::Label __docPanelGroupsLabel;

			/**
				\brief	Label to indicate how many art objects the document has
			*/
			hdi::core::Label __docPanelArtsLabel;

			/**
				\brief	Panel Plugin constructor
				\author	GW
				\date	10/2013
			*/
			Plugin(hdi::core::Plugin* const corePlug_);

			/**
				\brief	Destructs a panel Plugin object
				\author	GW
				\date	10/2013
			*/
			~Plugin();
			
			/**
				\brief	Recursively processes an artwork (sub)tree, counting how many art groups and plain art objects
						are seen along the way
				\author	GW
				\date	10/2013
				
				\param	art_		(Sub)root of artwork tree to process
				\param	numGroups__	Return-by-reference for number of groups seen while recursively traversing the tree
				\param	numArts__	Return-by-reference for number of art objs seen while recursively traversing the tree
				
				\note	Both numGroups__ and numArts__ will only be incremented each time one is seen, so "seed" this
						method with 0 for both arguments.
			*/
			void __countGroupsAndArts(const hdi::core::Art& art_, uint32_t& numGroups__, uint32_t& numArts__);
			
			/**
				\brief	Callback to save the current document
				\author	GW
				\date	10/2013
			*/
			void __saveDocCB();
			
			/**
				\brief	Callback for when the current document has been saved
				\author	GW
				\date	10/2013
			*/
			void __docWasSavedCB();
			
			/**
				\brief	Callback for when it's been an additional minute since the document was saved
				\author	GW
				\date	10/2013
			*/
			void __updateSaveTimeCB();
			
			/**
				\brief	Callback for when a document change notification is received
				\author	GW
				\date	10/2013
			*/
			void __docChangedCB();
			
			/**
				\brief	Callback for when an artboard change notification is received
				\author	GW
				\date	10/2013
			*/
			void __artboardChangedCB();
			
			/**
				\brief	Callback for when a layer change notification is received
				\author	GW
				\date	10/2013
			*/
			void __layerChangedCB();
			
			/**
				\brief	Callback for when an art change notification is received
				\author	GW
				\date	10/2013
			*/
			void __artChangedCB();
			
			/**
				\brief	Callback for when menu items need to have their text updated
				\author	GW
				\date	10/2013
			*/
			void __updateMenuItemsCB();
			
			/**
				\brief	Callback for when the doc stats panel menu item is selected
				\author	GW
				\date	10/2013
			*/
			void __docPanelMenuItemCB();
	};
}

#endif
// __PANEL_SAMPLE_PLUGIN__
