#ifndef __TOOL_SAMPLE_FORMATTING__
#define __TOOL_SAMPLE_FORMATTING__

#include <string>

#include "hdicoreTypes.h"

namespace tool
{
	/**
		\brief		Formats a numeric value to a string
		\author		GW
		\date		10/2013
		
		\param		val_		Numeric value to format
		\param		decimals_	Number of decimal places to use when formatting (maximum of 8 supported)
		\returns	A formatted string of the given value
	*/
	std::string formatNumber(const double val_, const int16_t decimals_ = 0);
	
	/**
		\brief		Scans a string for a numeric value
		\author		GW
		\date		10/2013
		
		\param		input_	Input string to scan for a value
		\param		val__	Return-by-reference for the scanned value
		\returns	true if scanning was successful, false otherwise
	*/
	bool scanNumber(const std::string& input_, double& val__);

	/**
		\brief		Formats a numeric points value to a string
		\author		GW
		\date		10/2013
		
		\param		pts_		Numeric points value to format
		\param		decimals_	Number of decimal places to use when formatting (maximum of 8 supported)
		\returns	A formatted string of the given points value
	*/
	std::string formatPoints(const double pts_, const int16_t decimals_ = 0);
	
	/**
		\brief		Scans a string for a numeric points value
		\author		GW
		\date		10/2013
		
		\param		input_	Input string to scan for a points value
		\param		pts__	Return-by-reference for the scanned points value
		\returns	true if scanning was successful, false otherwise
	*/
	bool scanPoints(const std::string& input_, double& pts__);
}

#endif
// __TOOL_SAMPLE_FORMATTING__
