/**
	\file
	\brief		Header file for defining various plugin constants
	\copyright	Hot Door, Inc. 2010-2026
*/

#ifndef __HDI_CORE_CONSTANTS__
#define __HDI_CORE_CONSTANTS__

namespace hdi
{
	namespace core
	{
		/**
			\brief	This error code is displayed graphically (at startup) when pluginSetup() returns false
		*/
		const long setupFailedErrorCode = 'SUFE';
	
		/**
			\brief		Maximum float type precision
			\details	C/C++ floats have, at most, 7 significant figures. This constant is useful for e.g. comparisons
						using the equalWithinTol() function.
		*/
		const double maxFloatPrecision	= 0.000001;
		
		/**
			\brief		Maximum double type precision
			\details	C/C++ doubles have, at most, 15 significant figures. This constant is useful for e.g. comparisons
						using the equalWithinTol() function.
		*/
		const double maxDoublePrecision	= 0.00000000000001;

		/**
			\brief	Number of thous (mils) per inch
		*/
		const double thousPerInch			= 1000.0;

		/**
			\brief	Number of millimeters per inch
		*/
		const double millimetersPerInch		= 25.4;

		/**
			\brief	Number of inches per foot
		*/
		const double inchesPerFoot			= 12.0;

		/**
			\brief	Number of feet per yard
		*/
		const double feetPerYard			= 3.0;

		/**
			\brief	Number of feet per mile
		*/
		const double feetPerMile			= 5280.0;

		/**
			\brief	Number of millimeters per centimeter
		*/
		const double millimetersPerCentimeter	= 10.0;

		/**
			\brief	Number of centimeters per meter
		*/
		const double centimetersPerMeter		= 100.0;

		/**
			\brief	Number of meters per kilometer
		*/
		const double metersPerKilometer			= 1000.0;

		/**
			\brief	Number of points per pica
		*/
		const double pointsPerPica = 12.0;

		/**
			\brief	Number of shakus per meter (this unit is only used in Japan)
		*/
		const double shakusPerMeter		= 3.3;

		/**
			\brief	Number of square points per acre
		*/
		const double sqPointsPerAcre	= 32517365759.9999999999999999999999999;

		/**
			\brief	Number of square points per hectare
		*/
		const double sqPointsPerHectare	= 80352160704.3214086428172856345712691;

		/**
			\brief	Number of points per thou (mil)
		*/
		const double pointsPerThou			= 0.072;

		/**
			\brief	Number of points per inch
		*/
		const double pointsPerInch			= 72.0;

		/**
			\brief	Number of points per foot
		*/
		const double pointsPerFoot			= 864.0;

		/**
			\brief	Number of points per yard
		*/
		const double pointsPerYard			= 2592.0;

		/**
			\brief	Number of points per mile
		*/
		const double pointsPerMile			= 4561920.0;

		/**
			\brief	Number of points per millimeter
		*/
		const double pointsPerMillimeter	= 2.83464566929133858267716535433070866;

		/**
			\brief	Number of points per centimeter
		*/
		const double pointsPerCentimeter	= 28.3464566929133858267716535433070866;

		/**
			\brief	Number of points per meter
		*/
		const double pointsPerMeter			= 2834.64566929133858267716535433070866;

		/**
			\brief	Number of points per kilometer
		*/
		const double pointsPerKilometer		= 2834645.66929133858267716535433070866;

		/**
			\brief	Number of points per shaku (this unit is only used in Japan)
		*/
		const double pointsPerShaku			= 858.983536148890479599141016463851109;

		/**
			\brief	Distance to travel away from an anchor point, relative to the desired circle radius, in order to
					create a control point that produces a circular arc.
			\note	See http://www.whizkidtech.redprince.net/bezier/circle/ for more info
		*/
		const double bezierKappa		= 0.55228474983079339840225163227959743;	// 4.0 * ((M_SQRT2 - 1.0) / 3.0);
		
		/**
			\brief	Similar to bezierKappa, but as the fraction of the diameter distance instead
		*/
		const double bezierMagicNumber	= 3.62132034355964257320253308631454711;	// 2.0 / bezierKappa

		/**
			\brief	Number of points in a 64th of an inch
		*/
		const double pointsForInch64th	= 1.125;

		/**
			\brief	Number of points in a 32nd of an inch
		*/
		const double pointsForInch32nd	= 2.25;

		/**
			\brief	Number of points in a 16th of an inch
		*/
		const double pointsForInch16th	= 4.5;

		/**
			\brief	Number of points in an eighth of an inch
		*/
		const double pointsForInch8th	= 9.0;

		/**
			\brief	Number of points in a quarter of an inch
		*/
		const double pointsForInch4th	= 18.0;

		/**
			\brief	Number of points in a half-inch
		*/
		const double pointsForHalfInch	= 36.0;
		
		/**
			\brief	Number of points in a millimeter
		*/
		const double pointsFor1mm		= 2.83464566929133858267716535433070866;
		
		/**
			\brief	Number of points in a centimeter
		*/
		const double pointsFor1cm		= 28.3464566929133858267716535433070866;
		
		/**
			\brief	Number of points in a meter
		*/
		const double pointsFor1meter	= 2834.64566929133858267716535433070866;
		
		/**
			\brief	Number of points in a kilometer
		*/
		const double pointsFor1km		= 2834645.66929133858267716535433070866;
	}
}

#endif
// __HDI_CORE_CONSTANTS__
