/**
	\file
	\brief		Header file for a variety of plugin convenience macros
	\copyright	Hot Door, Inc. 2010-2026
*/


#ifndef __HDI_CORE_MACROS__
#define __HDI_CORE_MACROS__

// HDI_CHANGE_WITH_EACH_NEW_LIB_VERSION
#if defined(HDI_CORE_COMPILE_AI30)
	#define HDI_CORE_APP_VERSION_NUMBER	30

	#define HDI_CORE_COMPILE_AI30_PLUS	1
	#define HDI_CORE_COMPILE_AI29_PLUS	1
	#define HDI_CORE_COMPILE_AI28_PLUS	1
	
	#define HDI_CORE_COMPILE_AI28_MINUS	0
	#define HDI_CORE_COMPILE_AI29_MINUS	0
	#define HDI_CORE_COMPILE_AI30_MINUS	1

	#define HDI_CORE_COMPILE_PS25_PLUS	0
	#define HDI_CORE_COMPILE_PS24_PLUS	0

	#define HDI_CORE_COMPILE_PS24_MINUS	0
	#define HDI_CORE_COMPILE_PS25_MINUS	0
#elif defined(HDI_CORE_COMPILE_AI29)
	#define HDI_CORE_APP_VERSION_NUMBER	29

	#define HDI_CORE_COMPILE_AI30_PLUS	0
	#define HDI_CORE_COMPILE_AI29_PLUS	1
	#define HDI_CORE_COMPILE_AI28_PLUS	1
	
	#define HDI_CORE_COMPILE_AI28_MINUS	0
	#define HDI_CORE_COMPILE_AI29_MINUS	1
	#define HDI_CORE_COMPILE_AI30_MINUS	1

	#define HDI_CORE_COMPILE_PS25_PLUS	0
	#define HDI_CORE_COMPILE_PS24_PLUS	0

	#define HDI_CORE_COMPILE_PS24_MINUS	0
	#define HDI_CORE_COMPILE_PS25_MINUS	0
#elif defined(HDI_CORE_COMPILE_AI28)
	#define HDI_CORE_APP_VERSION_NUMBER	28

	#define HDI_CORE_COMPILE_AI30_PLUS	0
	#define HDI_CORE_COMPILE_AI29_PLUS	0
	#define HDI_CORE_COMPILE_AI28_PLUS	1
	
	#define HDI_CORE_COMPILE_AI28_MINUS	1
	#define HDI_CORE_COMPILE_AI29_MINUS	1
	#define HDI_CORE_COMPILE_AI30_MINUS	1

	#define HDI_CORE_COMPILE_PS25_PLUS	0
	#define HDI_CORE_COMPILE_PS24_PLUS	0

	#define HDI_CORE_COMPILE_PS24_MINUS	0
	#define HDI_CORE_COMPILE_PS25_MINUS	0
#endif

// HDI_CHANGE_WITH_EACH_NEW_LIB_VERSION
#if defined(HDI_CORE_COMPILE_PS25)
	#define HDI_CORE_APP_VERSION_NUMBER	25

	#define HDI_CORE_COMPILE_AI30_PLUS	0
	#define HDI_CORE_COMPILE_AI29_PLUS	0
	#define HDI_CORE_COMPILE_AI28_PLUS	0
	
	#define HDI_CORE_COMPILE_AI28_MINUS	0
	#define HDI_CORE_COMPILE_AI29_MINUS	0
	#define HDI_CORE_COMPILE_AI30_MINUS	0

	#define HDI_CORE_COMPILE_PS25_PLUS	1
	#define HDI_CORE_COMPILE_PS24_PLUS	1

	#define HDI_CORE_COMPILE_PS24_MINUS	0
	#define HDI_CORE_COMPILE_PS25_MINUS	1
#elif defined(HDI_CORE_COMPILE_PS24)
	#define HDI_CORE_APP_VERSION_NUMBER	24

	#define HDI_CORE_COMPILE_AI30_PLUS	0
	#define HDI_CORE_COMPILE_AI29_PLUS	0
	#define HDI_CORE_COMPILE_AI28_PLUS	0
	
	#define HDI_CORE_COMPILE_AI28_MINUS	0
	#define HDI_CORE_COMPILE_AI29_MINUS	0
	#define HDI_CORE_COMPILE_AI30_MINUS	0

	#define HDI_CORE_COMPILE_PS25_PLUS	0
	#define HDI_CORE_COMPILE_PS24_PLUS	1

	#define HDI_CORE_COMPILE_PS24_MINUS	1
	#define HDI_CORE_COMPILE_PS25_MINUS	1
#endif

/**
	\brief	Helpers for the HDI_BREAK_BLOCK macro
*/
#define __HDI_CORE_BREAK_BLOCK_VAR(__HDI_N__)	__hdi_core_breakblock_ ## __HDI_N__
#define HDI_CORE_BREAK_BLOCK_VAR(__HDI_N__)	__HDI_CORE_BREAK_BLOCK_VAR(__HDI_N__)

/**
	\brief		Helps to create a guaranteed one-iteration while loop for easy cleanup control (a common C++
				practice, in one fashion or another)
	\details	Let's say you have a function with lots of initial conditions to check before proceeding with the
				desired task, but every time a condition fails lots of lines of cleanup code need to be executed.
				One way to approach this is with many nested if-blocks (ugly and hard to read), or with pasting the
				cleanup code in each sequential condition's block (hard to maintain and error prone). A much better
				alternative to either approach is to use a loop or switch to create a block within which the "break"
				keyword can be used, and put the cleanup code outside of the block (such that breaking out of the
				block or successfully executing the entirety of the block will always result in the same cleanup
				code being executed afterwards, and without any of the drawbacks of the aforementioned approaches).
*/
#define HDI_CORE_BREAK_BLOCK \
	short HDI_CORE_BREAK_BLOCK_VAR(__LINE__) = 0; \
	while( (++HDI_CORE_BREAK_BLOCK_VAR(__LINE__)) == 1 )

#endif
// __HDI_CORE_MACROS__
