#ifndef __ANNO_SAMPLE_PLUGIN__
#define __ANNO_SAMPLE_PLUGIN__

#include "hdicoreAnnotator.h"
#include "hdicoreCursor.h"
#include "hdicoreSize.h"
#include "hdicoreTool.h"

#define TOOL_PLUG_INST	anno::Plugin::instance()

namespace hdi
{
	namespace core
	{
		class Plugin;
	}
}

namespace anno
{
	class Plugin
	{
		public:
			/**
				\brief		Creates the singleton instance of the tool sample Plugin class
				\author		GW
				\date		03/2014
				
				\param		corePlug_	Pointer to the core Plugin object, as received by hdi::core::pluginSetup()
				
				\returns	The Plugin instance object
			*/
			static Plugin* const create(hdi::core::Plugin* const corePlug_);
		
			/**
				\brief		Acquires the singleton instance of the tool sample Plugin class
				\author		GW
				\date		03/2014
				
				\returns	The Plugin instance object
				
				\note		This method will always return NULL until create() has been called
			*/
			static Plugin* const instance();
			
			/**
				\brief	Destroys the singleton instance of the tool sample Plugin class
				\author	GW
				\date	03/2014
			*/
			static void destroy();
			
			/**
				\brief	Will be called when the plug-in is starting up (as set in toolSetup.cpp)
				\author	GW
				\date	03/2014
			*/
			void startup();
			
			/**
				\brief	Will be called when the plug-in has already started up, but still needs to set some things up
						(as set in toolSetup.cpp)
				\author	GW
				\date	03/2014
			*/
			void postStartup();
			
			/**
				\brief	Will be called when the plug-in is about to shutdown (as set in toolSetup.cpp)
				\author	GW
				\date	03/2014
			*/
			void preShutdown();
			
			/**
				\brief	Will be called when the plug-in is fully shutting down (as set in toolSetup.cpp)
				\author	GW
				\date	03/2014
			*/
			void shutdown();


		private:
			/**
				\brief	Singleton instance of the tool sample Plugin class
			*/
			static Plugin* __instance;
			
			/**
				\brief	Pointer to the core Plugin object
			*/
			hdi::core::Plugin* __corePlug;
			
			/**
				\brief	Crosshairs cursor for tools to use
			*/
			hdi::core::Cursor __crosshairsCrsr;
			
			/**
				\brief	Annotator for the rect tool (when selected)
			*/
			hdi::core::Annotator __toolAnno;
			
			/**
				\brief	Tool for drawing rectangles
			*/
			hdi::core::Tool __rectTool;
			
			/**
				\brief	Indicates whether the rect tool is currently dragging
			*/
			bool __rectToolDragging;
			
			/**
				\brief	Indicates the current/last size of the rect drawn by the rect tool
			*/
			hdi::core::Size __rectToolDragSize;

			/**
				\brief	Tool sample Plugin constructor
				\author	GW
				\date	03/2014
			*/
			Plugin(hdi::core::Plugin* const corePlug_);

			/**
				\brief	Destructs a tool sample Plugin object
				\author	GW
				\date	03/2014
			*/
			~Plugin();
			
			/**
				\brief	Called when the rect tool annotator should draw
			*/
			void __annoDrawDB();
			
			/**
				\brief	Called when the rect tool cursor tracking event is received
				\author	GW
				\date	03/2014
			*/
			void __rectToolTrackCB();
			
			/**
				\brief	Called when the rect tool has been dragged
				\author	GW
				\date	03/2014
			*/
			void __rectToolDragCB();
			
			/**
				\brief	Called when the mouse button has gone up with rect tool selected
				\author	GW
				\date	03/2014
			*/
			void __rectToolMouseUpCB();
			
			/**
				\brief	Called when the rect tool should draw
				\author	GW
				\date	03/2014
			*/
			void __rectToolDraw();
	};
}

#endif
// __ANNO_SAMPLE_PLUGIN__
