#include "annoPlugin.h"

#include <math.h>

#include "hdicoreAngle.h"
#include "hdicoreAnnotate.h"
#include "hdicoreArt.h"
#include "hdicoreArtboardRect.h"
#include "hdicoreCallback.h"
#include "hdicoreCurrentDocument.h"
#include "hdicoreDispatcher.h"
#include "hdicoreDocumentView.h"
#include "hdicoreDraw.h"
#include "hdicoreHitData.h"
#include "hdicoreIllustrator.h"
#include "hdicoreLayer.h"
#include "hdicorePlugin.h"

#include "annoFormatting.h"
#include "annoResourceIDs.h"



// MARK: Types

namespace anno
{
	typedef HDI_CORE_CALLBACK_T(anno::Plugin) PluginCB;
}

// MARK: - Tool Sample plugin lifecycle

anno::Plugin* anno::Plugin::__instance = NULL;

// static
anno::Plugin* const anno::Plugin::create(hdi::core::Plugin* const corePlug_)
{
	return (anno::Plugin::__instance = new anno::Plugin(corePlug_));
}

// static
anno::Plugin* const anno::Plugin::instance()
{
	return anno::Plugin::__instance;
}

// static
void anno::Plugin::destroy()
{
	delete anno::Plugin::__instance;
	anno::Plugin::__instance = NULL;
}

anno::Plugin::Plugin(hdi::core::Plugin* const corePlug_) :
	__corePlug(corePlug_),
	__crosshairsCrsr(
		AS_CROSSHAIRS_PNGI_RSRC_ID,
		hdi::core::Cursor::noneImageID,
		hdi::core::Cursor::noneImageID,
		hdi::core::Point(9.0, 9.0)
	),
	__rectToolDragging(false)
{
	this->__corePlug->setName("Hot Door Annotate Sample Plugin");
}

anno::Plugin::~Plugin()
{
	// This doesn't belong to us, so don't delete it
	this->__corePlug = NULL;
}

void anno::Plugin::startup()
{
	this->__toolAnno = hdi::core::Annotator(
		"AnnoSampleAnnotatorID",
		HDI_CORE_CALLBACK(anno::Plugin, this, __annoDrawDB)
	);
	this->__toolAnno.deactivate();
	this->__corePlug->dispatcher()->registerAnnotator(this->__toolAnno);

	this->__rectTool = hdi::core::Tool(
		hdi::core::Tool(),	// Not in same set as any other tool
		NULL,				// Not in same group as any other tool
		"Sample Rect Tool",
		"Sample Rect Tool",
		hdi::core::IconResourceTypePNGI,
		AS_RECT_PNGI_RSRC_ID,
		AS_RECT_DARK_PNGI_RSRC_ID
	);
	this->__rectTool.setTrackCallback(HDI_CORE_CALLBACK(anno::Plugin, this, __rectToolTrackCB));
	this->__rectTool.setDragCallback(HDI_CORE_CALLBACK(anno::Plugin, this, __rectToolDragCB));
	this->__rectTool.setMouseUpCallback(HDI_CORE_CALLBACK(anno::Plugin, this, __rectToolMouseUpCB));
	this->__rectTool.setDeselectionCallback(HDI_CORE_CALLBACK(hdi::core::Annotator, &this->__toolAnno, deactivate));
}

void anno::Plugin::postStartup()
{
	// Nothing to do here
}

void anno::Plugin::preShutdown()
{
	// Nothing to do here
}

void anno::Plugin::shutdown()
{
	this->__corePlug->dispatcher()->unregisterAnnotator(this->__toolAnno);
	this->__toolAnno.destroy();

	this->__rectTool.destroy();
}

// MARK: - Rect tool callbacks

void anno::Plugin::__annoDrawDB()
{
	hdi::core::CurrentDocument* currDoc = HDI_CORE_ILLUSTRATOR->currentDocument();
	if(!currDoc)
		return;

	hdi::core::annotate::setColor(hdi::core::Color::red());
	hdi::core::annotate::setFontType(hdi::core::annotate::PanelFont);

	const hdi::core::Point viewCursorPt = currDoc->currentView()->artworkPointToViewPoint(this->__rectTool.cursorLoc());
	const hdi::core::Point drawPt = viewCursorPt.offset(5.0, 5.0);
	
	std::string annoText = "(";
	annoText += anno::formatPoints(this->__rectTool.cursorLoc().x, 1);
	annoText += ",";
	annoText += anno::formatPoints(this->__rectTool.cursorLoc().y, 1);
	annoText += ")";
	
	if(this->__rectToolDragging)
	{
		annoText += "\n";
		annoText += anno::formatPoints(this->__rectToolDragSize.width, 1);
		annoText += " x ";
		annoText += anno::formatPoints(this->__rectToolDragSize.height, 1);
	}
	
	hdi::core::annotate::text(annoText, drawPt);
}

void anno::Plugin::__rectToolTrackCB()
{
	this->__crosshairsCrsr.enable();
	this->__toolAnno.activate();
}

void anno::Plugin::__rectToolDragCB()
{
	this->__rectToolDragging = true;

	this->__rectToolDraw();
}

void anno::Plugin::__rectToolMouseUpCB()
{
	this->__rectToolDraw();
	
	this->__rectToolDragging = false;
	
	this->__rectTool.resetCursorLocs();
}

void anno::Plugin::__rectToolDraw()
{
	std::unique_ptr<hdi::core::HitData> startHit = this->__rectTool.mouseDownHitData(0, hdi::core::AnyHitRequestNoGuides);
	if( !startHit.get() )
		return;

	if(this->__rectToolDragging)
	{
		std::unique_ptr<hdi::core::HitData> endHit = this->__rectTool.cursorHitData(hdi::core::AnyHitRequestNoGuides);
		if( !endHit.get() )
			return;

		this->__rectToolDragSize.width = endHit->point().x - startHit->point().x;
		this->__rectToolDragSize.height = endHit->point().y - startHit->point().y;
	}
	else if(this->__rectToolDragSize.width == 0.0 && this->__rectToolDragSize.height == 0.0)
	{
		this->__rectToolDragSize.width = this->__rectToolDragSize.height = 100.0;
	}
	
	const hdi::core::ArtboardRect bounds(startHit->point(), this->__rectToolDragSize);
	hdi::core::draw::rect(bounds);
}
