#ifndef __SKELETON_PLUGIN__
#define __SKELETON_PLUGIN__

#define SKEL_PLUG_INST	skel::Plugin::instance()

namespace hdi
{
	namespace core
	{
		class Plugin;
	}
}

namespace skel
{
	class Plugin
	{
		public:
			/**
				\brief		Creates the singleton instance of the skeleton Plugin class
				\author		GW
				\date		10/2013
				
				\param		corePlug_	Pointer to the core Plugin object, as received by hdi::core::pluginSetup()
				
				\returns	The Plugin instance object
			*/
			static Plugin* const create(hdi::core::Plugin* const corePlug_);
		
			/**
				\brief		Acquires the singleton instance of the skeleton Plugin class
				\author		GW
				\date		10/2013
				
				\returns	The Plugin instance object
				
				\note		This method will always return NULL until create() has been called
			*/
			static Plugin* const instance();
			
			/**
				\brief	Destroys the singleton instance of the skeleton Plugin class
				\author	GW
				\date	10/2013
			*/
			static void destroy();
			
			/**
				\brief	Will be called when the plug-in is starting up (as set in skelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void startup();
			
			/**
				\brief	Will be called when the plug-in has already started up, but still needs to set some things up
						(as set in skelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void postStartup();
			
			/**
				\brief	Will be called when the plug-in is about to shutdown (as set in skelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void preShutdown();
			
			/**
				\brief	Will be called when the plug-in is fully shutting down (as set in skelSetup.cpp)
				\author	GW
				\date	10/2013
			*/
			void shutdown();


		private:
			/**
				\brief	Singleton instance of the skeleton Plugin class
			*/
			static Plugin* __instance;
			
			/**
				\brief	Pointer to the core Plugin object
			*/
			hdi::core::Plugin* __corePlug;

			/**
				\brief	Skeleton Plugin constructor
				\author	GW
				\date	10/2013
			*/
			Plugin(hdi::core::Plugin* const corePlug_);

			/**
				\brief	Destructs a skeleton Plugin object
				\author	GW
				\date	10/2013
			*/
			~Plugin();
	};
}

#endif
// __SKELETON_PLUGIN__
