#include "skelPlugin.h"

#include <stddef.h>

#include "hdicorePlugin.h"



// MARK: Skeleton plugin lifecycle

skel::Plugin* skel::Plugin::__instance = NULL;

// static
skel::Plugin* const skel::Plugin::create(hdi::core::Plugin* const corePlug_)
{
	return (skel::Plugin::__instance = new skel::Plugin(corePlug_));
}

// static
skel::Plugin* const skel::Plugin::instance()
{
	return skel::Plugin::__instance;
}

// static
void skel::Plugin::destroy()
{
	delete skel::Plugin::__instance;
	skel::Plugin::__instance = NULL;
}

skel::Plugin::Plugin(hdi::core::Plugin* const corePlug_) : __corePlug(corePlug_)
{
	this->__corePlug->setName("Hot Door Skeleton Plugin");

	// Initialize/configure any other class members here
}

skel::Plugin::~Plugin()
{
	// This doesn't belong to us, so don't delete it
	this->__corePlug = NULL;

	// Clean up any other members or allocated memory here
}

void skel::Plugin::startup()
{
	// Here you can:
	// - Check your plug-in's compatibility against the running version of Illustrator
	// - Load/create preferences
	// - Load/create/verify user registration
	// - Subscribe to Illustrator messages and notifiers
	// - Create annotators and timers
	// - Create menu items (must be done during startup ONLY)
	// - Create tools (must be done during startup ONLY)
}

void skel::Plugin::postStartup()
{
	// Here you can:
	// - Create panels/control bars and their widgets (must be done during post-startup ONLY)
}

void skel::Plugin::preShutdown()
{
	// Here you can:
	// - Destroy panels/control bars and their widgets (must be done during pre-shutdown ONLY)
}

void skel::Plugin::shutdown()
{
	// Here you can:
	// - Unsubscribe from Illustrator messages and notifiers
	// - Destroy and unregister annotators and timers
	// - Destroy menu items (must be done during shutdown ONLY)
	// - Destroy tools (must be done during shutdown ONLY)
}
