#include "toolFormatting.h"

#include <algorithm>
#include <iomanip>
#include <sstream>



std::string tool::formatNumber(const double val_, const int16_t decimals_)
{
	std::stringstream os;
	os << std::fixed << std::setprecision( std::min(abs(decimals_), 8) ) << val_;
	return os.str();
}

bool tool::scanNumber(const std::string& input_, double& val__)
{
	if(input_.length() < 1)
		return false;
	
	double scannedVal = 0.0;
	if(sscanf(input_.c_str(), "%lf", &scannedVal) == 1)
	{
		val__ = scannedVal;
		return true;
	}
	
	return false;
}

std::string tool::formatPoints(const double pts_, const int16_t decimals_)
{
	return tool::formatNumber(pts_, decimals_) + " pts";
}

bool tool::scanPoints(const std::string& input_, double& pts__)
{
	if(input_.length() < 1)
		return false;

	std::string inputCopy;
	inputCopy.resize(input_.size());
	std::transform(input_.begin(), input_.end(), inputCopy.begin(), ::tolower);
	
	double scannedPts = 0.0;
	char unit1[2] = { '\0' }, unit2[2] = { '\0' };
	if(sscanf(inputCopy.c_str(), "%lf %[p]%[t]", &scannedPts, unit1, unit2) == 3)
	{
		pts__ = scannedPts;
		return true;
	}

	return tool::scanNumber(input_, pts__);
}
