#include <iostream>
#include <string>

#include "hdicoreCallback.h"
#include "hdicorePlugin.h"

#include "toolPlugin.h"



namespace hdi
{
	namespace core
	{
		void pluginLoaded()
		{
			// no-op
		}
	
		bool pluginSetup(Plugin* const plugin_)
		{
			tool::Plugin::create(plugin_);
		
			plugin_->setStartupCallback(HDI_CORE_CALLBACK(tool::Plugin, TOOL_PLUG_INST, startup));
			plugin_->setPostStartupCallback(HDI_CORE_CALLBACK(tool::Plugin, TOOL_PLUG_INST, postStartup));
			plugin_->setPreShutdownCallback(HDI_CORE_CALLBACK(tool::Plugin, TOOL_PLUG_INST, preShutdown));
			plugin_->setShutdownCallback(HDI_CORE_CALLBACK(tool::Plugin, TOOL_PLUG_INST, shutdown));
			
			return true;
		}
		
		void pluginDestroy(Plugin* const plugin_)
		{
			tool::Plugin::destroy();
		}
	}
}
